#!/sbin/sh
#
# /system/addon.d/97-i9506.sh
# During a CM12 upgrade, this script installs i9506 acdb files
# /system is formatted and reinstalled, then the file is restored.
#

. /tmp/backuptool.functions

list_files() {
cat <<EOF
bin/qcks
etc/Bluetooth_cal.acdb
etc/General_cal.acdb
etc/Global_cal.acdb
etc/Handset_cal.acdb
etc/Hdmi_cal.acdb
etc/Headset_cal.acdb
etc/Speaker_cal.acdb
EOF
}

case "$1" in
  backup)
    list_files | while read FILE DUMMY; do
      backup_file $S/"$FILE"
    done
  ;;
  restore)
    list_files | while read FILE REPLACEMENT; do
      R=""
      [ -n "$REPLACEMENT" ] && R="$S/$REPLACEMENT"
      [ -f "$C/$S/$FILE" ] && restore_file $S/"$FILE" "$R"
    done
  ;;
  pre-backup)
    # Stub
  ;;
  post-backup)
    # Stub
  ;;
  pre-restore)
    # Stub
  ;;
  post-restore)
    # Stub
  ;;
esac
