#!/sbin/sh

# ensure /data is mounted
mount /data

# prevent kernel flash
rm -f /dev/block/mmcblk0p5

# prevent cache format
rm -f /dev/block/mmcblk0p8
# for SHV-E210L
rm -f /dev/block/mmcblk0p9

# prevent system format & mount
umount -f /system
umount -l /system
rm -f /dev/block/mmcblk0p9
# for SHV-E210L
rm -f /dev/block/mmcblk0p10

# create link points
mkdir /data/arter97_secondrom
mkdir /data/arter97_secondrom/system
mkdir /data/arter97_secondrom/data
mkdir /data/arter97_secondrom/cache
chown root:root /data/arter97_secondrom/system
chown system:system /data/arter97_secondrom/data
chown system:cache /data/arter97_secondrom/cache
chmod 755 /data/arter97_secondrom/system
chown 771 /data/arter97_secondrom/data
chown 770 /data/arter97_secondrom/cache

# symlink /system
mount -o rw,remount rootfs
mount -o rw,remount /
rm -rf /system
ln -s /data/arter97_secondrom/system /system

# done :D
sync
