#!/sbin/sh

# ensure /data is mounted
mount /data

# prevent kernel flash
rm -f /dev/block/mmcblk0p5

# prevent system format & mount
umount -f /system
umount -l /system
rm -f /dev/block/mmcblk0p9
# for SHV-E210L
rm -f /dev/block/mmcblk0p10

# create link points
mkdir /data/arter97_secondrom
mkdir /data/arter97_secondrom/system
mkdir /data/arter97_secondrom/data
mkdir /data/arter97_secondrom/cache
chown root:root /data/arter97_secondrom/system
chown system:system /data/arter97_secondrom/data
chown system:cache /data/arter97_secondrom/cache
chmod 755 /data/arter97_secondrom/system
chown 771 /data/arter97_secondrom/data
chown 770 /data/arter97_secondrom/cache

mkdir -p /data/arter97_secondrom/data/misc/audit
mkdir -p /data/arter97_secondrom/data/system/dropbox
chown system:misc /data/arter97_secondrom/data/misc
chmod 1771 /data/arter97_secondrom/data/misc
chown audio:system /data/arter97_secondrom/data/misc/audit
chmod 2750 /data/arter97_secondrom/data/misc/audit
chown system:system /data/arter97_secondrom/data/system
chmod 775 /data/arter97_secondrom/data/system
chown system:system /data/arter97_secondrom/data/system/dropbox
chmod 700 /data/arter97_secondrom/data/system/dropbox

# prevent 1st-ROM /data corruption
# arter97 kernel's ramdisk revert this chattr +i on boot
chattr +i /data/app
chattr +i /data/app-asec
chattr +i /data/app-lib
chattr +i /data/app-private
chattr +i /data/dalvik-cache
chattr +i /data/data
chattr +i /data/local
chattr +i /data/system

# prepare /system
mount -o rw,remount rootfs
mount -o rw,remount /
# dirty hack
# allow 20 zips to be installed that have /system unmount syntax
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system
mount --bind /data/arter97_secondrom/system /system

# done :D
sync
