echo off
cls

echo Welcome to 'arter97 kernel for LG G Watch' installer 2.1!
echo.
echo This installer will do the followings :
echo 1. Remove previously installed kernel and install 'arter97 kernel for LG G Watch'
echo 2. If you're not on f2fs already, wipe all of your data and re-format to f2fs
echo    This will make your device's initial boot after installation a lot longer
echo    because it regenerates all of the ART caches. Be patient and allow upto 20 minutes.
echo.
echo In prior to the installation, your LG G Watch needs to have :
echo 1. On stock Android 5.0.1 Lollipop
echo 2. Enabled ADB debugging
echo 3. Unlocked bootloader
echo.
echo You need to know :
echo 1. Installing this will void your warranty.
echo 2. Developer is not responsible for any damages caused to your device.
echo 3. You cannot use stock / custom recovery after installing this kernel
echo    until you install stock firmware again.
echo    (Because of f2fs)
echo    If you want to use stock / custom recovery, remove f2fs_wipe.img
echo    before installation. That step will skip the installation of f2fs.
echo 4. You can no longer receive OTA updates for your device
echo    until you install stock firmware again.
echo.
echo If you have trouble in "Detecting device",
echo follow these instructions: http://bit.ly/gwatchadb
echo.

pause
echo.

echo Detecting device ...
:_adbloop1
ping -n 2 127.0.0.1 1>nul 2>nul
adb.exe shell echo connected 1>nul 2>nul
if not "%errorlevel%"=="0" @goto :_adbloop1

set f2fs=1
adb.exe shell mount | findstr /r /c:"f2fs" 1>nul 2>nul
if not "%errorlevel%"=="0" @set f2fs=0
if not exist f2fs_wipe.img @set f2fs=1
echo done

echo Rebooting into fastboot environment ...
adb.exe reboot bootloader
fastboot.exe wait 1>nul 2>nul
echo done

echo Flashing 'arter97 kernel for LG G Watch' ...
fastboot.exe flash boot boot.img 1>nul 2>nul
echo done

if "%f2fs%"=="0" (
	echo Formatting to f2fs - this will reboot your device ...
	fastboot.exe boot f2fs_wipe.img 1>nul 2>nul
	echo done
) else (
	fastboot.exe reboot
)

echo Installation finished!
echo.
echo Enjoy. Brought to you by @arter97
pause > nul
