#!/bin/bash

clear

echo "Welcome to 'arter97 kernel for LG G Watch' installer 2.2!

This installer will do the followings :
1. Remove previously installed kernel and install 'arter97 kernel for LG G Watch'
2. If you're not on f2fs already, wipe all of your data and re-format to f2fs
   This will make your device's initial boot after installation a lot longer
   because it regenerates all of the ART caches. Be patient and allow upto 20 minutes.

In prior to the installation, your LG G Watch needs to have :
1. On stock Android 5.0.1 Lollipop
2. Enabled ADB debugging
3. Unlocked bootloader

You need to know :
1. Installing this will void your warranty.
2. Developer is not responsible for any damages caused to your device.
3. You cannot use stock / custom recovery after installing this kernel
   until you install stock firmware again.
   (Because of f2fs)
   If you want to use stock / custom recovery, remove f2fs_wipe.img
   before installation. That step will skip the installation of f2fs.
4. You can no longer receive OTA updates for your device
   until you install stock firmware again.
   Do not attempt to install OTA updates!
"

read -p "Press any key to continue ..."

echo ""

echo -n "Detecting device ... "
until ./adb shell echo 1 > /dev/null 2>&1; do sleep 1; done
f2fs=0
if ./adb shell mount | grep -q f2fs ; then f2fs=1; fi
if [ ! -e f2fs_wipe.img ]; then
	f2fs=1
fi
echo "done"

echo -n "Rebooting into fastboot environment ... "
./adb reboot bootloader
./fastboot wait > /dev/null 2>&1
echo "done"

echo -n "Flashing 'arter97 kernel for LG G Watch' ... "
./fastboot flash boot boot.img > /dev/null 2>&1
echo "done"

if [ $f2fs == "0" ]; then
	echo -n "Formatting to f2fs(this will reboot your device) ... "
	./fastboot boot f2fs_wipe.img > /dev/null 2>&1
	until ./adb shell echo 1 > /dev/null 2>&1; do sleep 1; done
	echo "done"
else
	./fastboot reboot
fi

echo "Installation finished!

Enjoy. Brought to you by @arter97"
